/*:
 * @plugindesc Returns to Recollection List after a common event finishes if started from Recollection Mode.
 * @help
 * This plugin ensures that after a common event finishes in Recollection Mode,
 * the player is automatically returned to the Recollection List.
 */

(function() {
    var _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function() {
        _Scene_Map_update.call(this);
        if (Scene_Recollection._rngd_recollection_doing && !$gameTemp.isCommonEventReserved()) {
            console.log("Returning to recollection list after common event");
            Scene_Recollection._rngd_recollection_doing = false;
            Scene_Recollection.reload_rec_list = true;
            $gameTemp.clearCommonEvent(); // コモンイベントの予約をクリア
            console.log("Common event cleared in Scene_Map update");
            SceneManager.push(Scene_Recollection);
        }
    };

    var _Game_Interpreter_command115 = Game_Interpreter.prototype.command115;
    Game_Interpreter.prototype.command115 = function() {
        var result = _Game_Interpreter_command115.call(this);
        if (Scene_Recollection._rngd_recollection_doing) {
            console.log("Ending common event and returning to recollection list");
            Scene_Recollection._rngd_recollection_doing = false;
            Scene_Recollection.reload_rec_list = true;
            $gameTemp.clearCommonEvent(); // コモンイベントの予約をクリア
            console.log("Common event cleared in command115");
            SceneManager.push(Scene_Recollection);
        }
        return result;
    };

    Scene_Recollection.prototype.rngd_exit_scene = function() {
        console.log("rngd_exit_scene called");
        if (Scene_Recollection._rngd_recollection_doing) {
            console.log("Exiting recollection mode");
            Scene_Recollection._rngd_recollection_doing = false;
            Scene_Recollection.reload_rec_list = true;
            console.log("Before SceneManager.pop()");
            SceneManager.pop();
            console.log("After SceneManager.pop()");
        } else {
            console.log("Not in recollection mode");
        }
    };
})();






